/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NFor
extends NNode {
    static final long serialVersionUID = 3228529969554646406L;
    public NNode target;
    public NNode iter;
    public NBlock body;
    public NBlock orelse;

    public NFor(NNode nNode, NNode nNode2, NBlock nBlock, NBlock nBlock2) {
        this(nNode, nNode2, nBlock, nBlock2, 0, 1);
    }

    public NFor(NNode nNode, NNode nNode2, NBlock nBlock, NBlock nBlock2, int n, int n2) {
        super(n, n2);
        this.target = nNode;
        this.iter = nNode2;
        this.body = nBlock;
        this.orelse = nBlock2;
        this.addChildren(nNode, nNode2, nBlock, nBlock2);
    }

    public boolean bindsName() {
        return true;
    }

    protected void bindNames(Scope scope) throws Exception {
        this.bindNames(scope, this.target, NameBinder.make());
    }

    private void bindNames(Scope scope, NNode nNode, NameBinder nameBinder) throws Exception {
        if (nNode instanceof NName) {
            nameBinder.bind(scope, (NName)nNode, (NType)new NUnknownType());
            return;
        }
        if (nNode instanceof NSequence) {
            for (NNode nNode2 : ((NSequence)nNode).getElements()) {
                this.bindNames(scope, nNode2, nameBinder);
            }
        }
    }

    public NType resolve(Scope scope) throws Exception {
        NameBinder.make().bindIter(scope, this.target, this.iter);
        if (this.body == null) {
            this.setType(new NUnknownType());
        } else {
            this.setType(NFor.resolveExpr(this.body, scope));
        }
        if (this.orelse != null) {
            this.addType(NFor.resolveExpr(this.orelse, scope));
        }
        return this.getType();
    }

    public String toString() {
        return "<For:" + this.target + ":" + this.iter + ":" + this.body + ":" + this.orelse + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNode(this.target, nNodeVisitor);
            this.visitNode(this.iter, nNodeVisitor);
            this.visitNode(this.body, nNodeVisitor);
            this.visitNode(this.orelse, nNodeVisitor);
        }
    }
}

